#include <iostream>
using namespace std;

#define N 8

int board[N][N]; // 8x8 chessboard

// Function to print the board
void printBoard() {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            cout << board[i][j] << " ";
        }
        cout << endl;
    }
    cout << endl;
}

// Function to check if placing a queen at board[row][col] is safe
bool isSafe(int row, int col) {
    int i, j;

    // Check this column on upper rows
    for (i = 0; i < row; i++)
        if (board[i][col])
            return false;

    // Check upper left diagonal
    for (i = row - 1, j = col - 1; i >= 0 && j >= 0; i--, j--)
        if (board[i][j])
            return false;

    // Check upper right diagonal
    for (i = row - 1, j = col + 1; i >= 0 && j < N; i--, j++)
        if (board[i][j])
            return false;

    return true;
}

// Recursive function to solve 8-Queens problem
bool solveNQueens(int row) {
    // Base Case: If all queens are placed
    if (row == N)
        return true;

    // Skip row 0 (first queen is already placed)
    if (row == 0)
        return solveNQueens(row + 1);

    // Try placing this queen in all columns
    for (int col = 0; col < N; col++) {
        if (isSafe(row, col)) {
            board[row][col] = 1; // place queen
            if (solveNQueens(row + 1)) // recursive call
                return true;
            board[row][col] = 0; // backtrack
        }
    }

    return false; // no valid placement found
}

int main() {
    // Initialize board to 0
    for (int i = 0; i < N; i++)
        for (int j = 0; j < N; j++)
            board[i][j] = 0;

    int firstCol;
    cout << "Enter the column (0 to 7) where the first queen is placed in row 0: ";
    cin >> firstCol;

    // Place first queen at (0, firstCol)
    board[0][firstCol] = 1;

    // Solve for remaining queens
    if (solveNQueens(0)) {
        cout << "\nFinal 8-Queens Solution:\n";
        printBoard();
    } else {
        cout << "No solution exists for this initial placement.\n";
    }

    return 0;
}
