#include <iostream>
#include <algorithm>
using namespace std;

// Structure to store item information
struct Item {
    int weight;
    int profit;
    double ratio; // profit/weight ratio
};

// Comparison function to sort items by decreasing ratio
bool compare(Item a, Item b) {
    return a.ratio > b.ratio;
}

int main() {
    int n;
    double capacity;

    cout << "Enter number of items: ";
    cin >> n;

    Item items[n];
    cout << "Enter profit and weight for each item:\n";
    for (int i = 0; i < n; i++) {
        cin >> items[i].profit >> items[i].weight;
        items[i].ratio = (double)items[i].profit / items[i].weight;
    }

    cout << "Enter knapsack capacity: ";
    cin >> capacity;

    // Step 1: Sort items by profit/weight ratio (descending)
    sort(items, items + n, compare);

    double totalProfit = 0.0;
    double remainingCapacity = capacity;

    cout << "\nItems considered (Profit/Weight/Ratio):\n";
    for (int i = 0; i < n; i++)
        cout << items[i].profit << "/" << items[i].weight << "/" << items[i].ratio << "\n";

    // Step 2: Pick items greedily
    for (int i = 0; i < n; i++) {
        if (items[i].weight <= remainingCapacity) {
            // Take the whole item
            totalProfit += items[i].profit;
            remainingCapacity -= items[i].weight;
        } else {
            // Take fractional part
            totalProfit += items[i].ratio * remainingCapacity;
            break;
        }
    }

    cout << "\nMaximum Profit: " << totalProfit << endl;

    return 0;
}
